#ifdef __cplusplus
#define DPI_LINKER_DECL  extern "C"
#else
#define DPI_LINKER_DECL
#endif

#include "acc.h"

#if 1
    #define NIC_DPRINTF(fmt, ...)                                           \
    do {                                                                    \
        fprintf(stderr, "NIC: " fmt, ##__VA_ARGS__);                        \
    } while (0)
#else
    #define NIC_DPRINTF(fmt, ...)
#endif

DPI_LINKER_DECL void C_send_packet(int id, int size, unsigned char *data);
DPI_LINKER_DECL void C_nic_poll(unsigned char* req, unsigned int* len, unsigned int* strobe, unsigned char* data);
DPI_LINKER_DECL void C_setup_nic_connection();

//Globals
zsock_t *nic_req = NULL;
zsock_t *nic_resp = NULL;
zpoller_t *poller_nic = NULL;


void C_teardown_nic_connection() {
    //deinit poller_nic
    zpoller_destroy(&poller_nic);
    //deinit 0mq sockets
    zsock_destroy(&nic_req);
    zsock_destroy(&nic_resp);
    
    //NIC_DPRINTF("socket connection teardown complete.\n");
}

//DPI functions
void C_setup_nic_connection() {
    int port = atoi(getenv("COSIM_PORT"));
    //initialize 0mq sockets
    char buffer[50];
    sprintf(buffer, SOCK_BASE, RECV_SOCK, port + 4);
    nic_req = zsock_new_pull(buffer);     //nic request
    sprintf(buffer, SOCK_BASE, SEND_SOCK, port + 5);
    nic_resp = zsock_new_push(buffer);    //nic response
    assert(nic_req && nic_resp);
    //set up 0mq poller_nic
    poller_nic = zpoller_new(nic_req, NULL);
    assert(poller_nic);

    atexit(C_teardown_nic_connection);

    //NIC_DPRINTF("socket connection setup complete.\n");
}

void C_send_packet(int id, int size, unsigned char *data) {
    
    int rv;

    ACCNICData acc_data;
    //memset(&acc_data, 0, sizeof(ACCNICData));
    //Copy write data to correct location
    acc_data.id = id;
    acc_data.size = size;
    memcpy(acc_data.data, data, BUFSZ);
    zframe_t *frame = zframe_new (&acc_data, sizeof(ACCNICData));
    assert(frame);
    //Send frame
    rv = zframe_send(&frame, nic_resp, 0);
    assert(rv == 0);
    NIC_DPRINTF("NIC: Sent request to QEMU\n");
    return;
}

void C_nic_poll(unsigned char* req, unsigned int* len, unsigned int* keep, unsigned char* data) {
    //Poll for a frame from qemu
    *req = 0;
    zsock_t *sock = zpoller_wait(poller_nic, 0);
    if(sock != nic_req) {
        return;
    }
    NIC_DPRINTF("NIC: Recieved request from QEMU\n");
    //qemu sent data
    zframe_t *frame = zframe_recv(nic_req);
    assert(frame);
    ACCNICData *acc_data = (ACCNICData*) zframe_data(frame);
    uint32_t size = acc_data->size;
    uint32_t align_offset = (size % 8);
    size = (align_offset) ? size / 8 : size / 8 - 1;
    uint8_t strobe = (1 << align_offset) - 1;
    if ( ! align_offset )
        strobe = ~strobe;
    // Set signals
    *req = 1;
    *len = size;
    *keep = strobe;
    memcpy(data, acc_data->data, BUFSZ);
    //Clean resource
    NIC_DPRINTF("NIC: DMA Controller. Len: %d\tKeep: %x\n", *len, *keep);
    int i;
    for(i = 0; i < 8; i++) {
        fprintf(stderr, "%x ", data[i]);
    }
    fprintf(stderr, "\n");
    zframe_destroy(&frame);
}
